<!DOCTYPE html>
<html>

<head>
  <title>Reports</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet"
  integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous">
  
  
  <style>
    @import url('https://fonts.googleapis.com/css?family=Roboto:400,700');

body {
  font-family: 'ROboto', sans-serif;
}

h2 {
  font-weight: 800 !important;
    margin-bottom: 0px !important;
    font-size: 25px !important;
    line-height: 30px !important;
    letter-spacing: normal !important;
    padding-top: 2px !important;
    padding-bottom: 2px !important;
    color: rgb(72, 72, 72) !important;
}


figure {
/*   width:30%; */
  /* position:relative; */
  /* padding:5px; */
}

figure img {
  width:100%;
  border-radius:3px;
}

figcaption.inside{
  position:absolute;
  /* top:20px;
  left:20px; */
 }

figcaption.inside h2 {
  color:white;
}

span {
  display:block;
}

.text-desc {
  font-size:14px!important;
/*       font-size: 16px !important; */
    line-height: 22px !important;
    padding-top: 0px !important;
    padding-bottom: 0px !important;
    color: rgb(72, 72, 72) !important;
    font-weight: normal !important;
    margin-top: 0px !important;
}

.text-color {
  color:rgb(255, 180, 0)!important;
  font-size:25px!important;
}


  </style>
</head>

<body>
  
  <div class="container">
    <div class="row">
       
      <script>  function getRandomColor(index) {
        const colors = [
          '#3498db',
          '#2ecc71',
          '#e74c3c',
          '#f39c12',
          '#9b59b6',
          '#34495e',
          '#1abc9c',
          '#e67e22',
          '#d35400',
          '#27ae60',
      ];
      return colors[index]
       
  }</script>
      
      <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
      


      <div>
      <div class="title mb-1">
              <h2><strong>Total results:</strong> <?php echo e($reportcount); ?></h2>
              <!-- <p>Browse a new selection of homes verified for quality & comfort</p> -->
            </div>
        <?php $__currentLoopData = $reports; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $report): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <a href="<?php echo e(route('public_report_show', ['reportid' => $report->reportid,'tool_table_name' => $report->tool_table_name])); ?>" style="text-decoration:none;">
        <section id="boat_services" class="my-5">
          <div class="container ">
            
            <div class="row">
               
              <div class="col-md-4">
                <div class="card">
                <div>
                <canvas id="chart_<?php echo e($report->json_index); ?>" class="card-img-top"></canvas>
               
              <figcaption class="outside card-footer text-muted" >
                <h3 class=" text-color mb-0"><?php echo e($report->report_name); ?></h3>
                <p class="text-desc"><?php echo e($report->description); ?> </p>
              </figcaption>
</div>
            </div>
              </div>
               
            </div>
            
          </div>
        </section>
</a>
        
        <!-- <a href="<?php echo e(route('public_report_show', ['reportid' => $report->reportid,'tool_table_name' => $report->tool_table_name])); ?>" class="flex flex--top flex--spacing20 margin-neg-bottom-10 text--linkReset">
          
           
          <div>
          <canvas id="chart_<?php echo e($report->json_index); ?>"></canvas>
          </div>

          <div class="flex__item flex__item--basis flex__item--grow display-block">

            <div class="reportResult__content">
              <h3 class="h4 text-semibold margin-bottom-0">
                <?php echo e($report->report_title); ?> 
              </h3>
              <p class="text-color--dark-blue-gray margin-top-15 padding-bottom-10 border-bottom-gray10-1">
                <?php echo e($report->description); ?> 
              </p>
              <div class="flex flex--spacing25 font-size-s margin-top-10">
                <div class="flex flex--spacing25 font-size-s margin-top-10">
                   
                  <span class="flex__item display-inline padding-bottom-10"><i aria-hidden="true" class="fa fa-clock-o"></i> Published in 
                    <span class="text-semibold">
                     <?php echo e(\Carbon\Carbon::parse($report->p_date)->format('F Y')); ?>

                    </span>
                  </span> 
                </div>
              </div>
            </div>

          </div>


        </a> -->
      <script>
        var ctx = document.getElementById('chart_<?php echo e($report->json_index); ?>').getContext('2d');
      var myChart = new Chart(ctx, {
      type: '<?php echo e($report->chart_type); ?>',
      data: {
          labels: [
              <?php $__currentLoopData = $chartdata[$report->json_index]['chart_heading']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $year): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  '<?php echo e($year); ?>',
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          ],
          datasets: [
              <?php $__currentLoopData = $chartdata[$report->json_index]['data']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $dataSet): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  {
                      label: '<?php echo e($dataSet['label']); ?>',
                      data: [
                          <?php $__currentLoopData = $dataSet['data']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                              <?php echo e($value); ?>,
                          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                      ],
                      borderColor: getRandomColor(<?php echo e($index); ?>),
                      backgroundColor: getRandomColor(<?php echo e($index); ?>),
                      fill: false
                  },
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          ]
      },
      options: {
          responsive: true,
          maintainAspectRatio: true,
          plugins:{
            legend : false
          },
          scales: {
              yAxes: [{
                  ticks: {
                      beginAtZero: true
                  }
              }]
          }
      }
  });
      </script>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


        

                  </div>
                </div>
              </div>
             
            </body>
            </html>







            <?php /**PATH /var/www/html/vipulgarg/resources/views/reportlist.blade.php ENDPATH**/ ?>