<!DOCTYPE html>
<html>

<head>
  <title>Reports</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet"
  integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous">
  
  
  <style>
    @import url('https://fonts.googleapis.com/css?family=Roboto:400,700');

body {
  font-family: 'ROboto', sans-serif;
}

h2 {
  font-weight: 800 !important;
    margin-bottom: 0px !important;
    font-size: 25px !important;
    line-height: 30px !important;
    letter-spacing: normal !important;
    padding-top: 2px !important;
    padding-bottom: 2px !important;
    color: rgb(72, 72, 72) !important;
}


figure {
/*   width:30%; */
  /* position:relative; */
  /* padding:5px; */
}

figure img {
  width:100%;
  border-radius:3px;
}

figcaption.inside{
  position:absolute;
  /* top:20px;
  left:20px; */
 }

figcaption.inside h2 {
  color:white;
}

span {
  display:block;
}

.text-desc {
  font-size:14px!important;
/*       font-size: 16px !important; */
    line-height: 22px !important;
    padding-top: 0px !important;
    padding-bottom: 0px !important;
    color: rgb(72, 72, 72) !important;
    font-weight: normal !important;
    margin-top: 0px !important;
}

.text-color {
  color:rgb(255, 180, 0)!important;
  font-size:25px!important;
}


  </style>
</head>

<body>
  
  <div class="container">
    <div class="row">
       
      <script>  function getRandomColor(index) {
        const colors = [
          '#3498db',
          '#2ecc71',
          '#e74c3c',
          '#f39c12',
          '#9b59b6',
          '#34495e',
          '#1abc9c',
          '#e67e22',
          '#d35400',
          '#27ae60',
      ];
      return colors[index]
       
  }</script>
      
      <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
      


      <div>
      <div class="title mb-1">
              <h2><strong>Total results:</strong> {{$reportcount}}</h2>
              <!-- <p>Browse a new selection of homes verified for quality & comfort</p> -->
            </div>
        @foreach ($reports as $report)
        <a href="{{ route('public_report_show', ['reportid' => $report->reportid,'slug' => $report->slug]) }}" style="text-decoration:none;">
        <section id="boat_services" class="my-5">
          <div class="container ">
            
            <div class="row">
               
              <div class="col-md-4">
                <div class="card">
                <div>
                <canvas id="chart_{{$report->json_index}}" class="card-img-top"></canvas>
               
              <figcaption class="outside card-footer text-muted" >
                <h3 class=" text-color mb-0">{{$report->report_name}}</h3>
                <p class="text-desc">{{$report->description}} </p>
              </figcaption>
</div>
            </div>
              </div>
               
            </div>
            
          </div>
        </section>
</a>
        

      <script>
        var ctx = document.getElementById('chart_{{$report->json_index}}').getContext('2d');
      var myChart = new Chart(ctx, {
      type: '{{$report->chart_type}}',
      data: {
          labels: [
              @foreach($chartdata[$report->json_index]['chart_heading'] as $year)
                  '{{ $year }}',
              @endforeach
          ],
          datasets: [
              @foreach($chartdata[$report->json_index]['data'] as $index => $dataSet)
                  {
                      label: '{{ $dataSet['label'] }}',
                      data: [
                          @foreach($dataSet['data'] as $value)
                              {{ $value }},
                          @endforeach
                      ],
                      borderColor: getRandomColor({{$index}}),
                      backgroundColor: getRandomColor({{$index}}),
                      fill: false
                  },
              @endforeach
          ]
      },
      options: {
          responsive: true,
          maintainAspectRatio: true,
          plugins:{
            legend : false
          },
          scales: {
              yAxes: [{
                  ticks: {
                      beginAtZero: true
                  }
              }]
          }
      }
  });
      </script>
        @endforeach


        

                  </div>
                </div>
              </div>
             
            </body>
            </html>







            