<div class="form-floating mb-2">
    @if ($type === 'textarea')
        <textarea class="form-control {{ $class }}" name="{{ $name }}" placeholder="{{ $placeholder }}"
            id="{{ $name }}" rows="4" cols="50">{{ $value }}</textarea>
    @elseif ($type === 'select')
        <select id="{{ $name }}" name="{{ $name }}" class="form-select {{ $class }}"
            @if ($required) required @endif>
            <option class='cusoption' value="" disabled selected >{{ $label }}</option>
            @foreach ($options as $optionLabel => $optionValue)
                <option  class='cusoption' value="{{ $optionValue }}" {{ $optionValue == $value ? 'selected' : '' }}>
                    {{ $optionLabel }}
                </option>
            @endforeach
        </select>
    @elseif ($type === 'radio')
        <div class="d-flex">
            <h5 class="mr-5">
                {{ $placeholder }}
                @if ($required)
                    <span class="text-danger"> * </span>
                @endif
            </h5>

            @foreach ($options as $optionLabel => $optionValue)
            <div class="form-check form-check-inline">
                <input class="form-check-input {{ $class }}" type="radio" name="{{ $name }}"
                    id="{{ $name . '_' . $loop->index }}" value="{{ $optionValue }}"
                    {{ $optionValue == $value ? 'checked' : '' }} @if ($required) required @endif >
                <label class="form-check-label" for="{{ $name . '_' . $loop->index }}">
                    {{ $optionLabel }}
                </label>
            </div>
        @endforeach
        </div>
        @elseif ($type === 'number')
        <input type="number" class="form-control {{ $class }}" name="{{ $name }}" id="{{ $name }}"
            placeholder="{{ $placeholder }}" value="{{ $value }}"  @if (isset($min)) min="{{ $min }}" @endif
            @if (isset($max)) max="{{ $max }}" @endif  @if ($required) required @endif >
        <label for="{{ $name }}">{{ $label }} @if ($required)
                <span class="text-danger"> * </span>
            @endif </label>
    @else
        <input type="{{ $type }}" class="form-control {{ $class }}" name="{{ $name }}"
            id="{{ $name }}" placeholder="{{ $placeholder }}" value="{{ $value }}"
            @if ($required) required @endif >
        <label for="{{ $name }}">{{ $label }} @if ($required)
                <span class="text-danger"> * </span>
            @endif </label>
    @endif
    @error($name)
        <span class="text-danger">{{ $message }}</span>
    @enderror
</div>
