<x-views.edit-blade label="Sub-Domain">
    <form method="post" action="{{ route($curr_url_1 . '.' . $curr_url_2 . '.update',$reportsubcategory->id) }}" @class(['p-4'])>
        @csrf
        @method('PUT')
        <x-form.input-component name="category_id" label="Select Sub-Domain" placeholder="Select Sub-Domain"
            :options="$categories" type="select" required="true" value="{{ $reportsubcategory->category_id }}" />
        <x-form.input-component name="subcategory_title" label="Sub Category Title"
            placeholder="Sub Category Title" value="{{ $reportsubcategory->subcategory_title }}" required="true" />
        <x-form.input-component name="slug" label="Slug" placeholder="Slug" value=" {{ $reportsubcategory->slug }}"
            required="true" />
        <label for="description">Description <span class="text-danger"> * </span> </label>
        <x-form.input-component name="description" type="textarea" class="ckeditor" label="Description"
            placeholder="Description" value=" {!! $reportsubcategory->description !!}" />
        <x-form.input-component name="seo_title" label="SEO Title" placeholder="SEO Title"
            value=" {{ $reportsubcategory->seo_title }}" required="true" />
        <label for="meta_description">Meta Description <span class="text-danger"> * </span> </label>
        <x-form.input-component name="meta_description" type="textarea" label="Meta Description"
            placeholder="Meta Description" value=" {!! $reportsubcategory->meta_description !!}" />

        <button type="submit" class="btn btn-success mt-2">Save {{ ucfirst($curr_url_2) }}</button>
    </form>
    @section('scripts')
        <script>
            $('#blog_category').change(function(e) {
                var title = $(this).val();
                var modelName = 'BlogCategory';

                $.ajax({
                    type: 'GET',
                    url: '{{ route('generateSlug') }}',
                    data: {
                        title: title,
                        modelName: modelName
                    },
                    dataType: 'json',
                    success: function(data) {
                        $('#slug').val(data.slug);
                    },
                    error: function(error) {
                        console.error('Ajax error:', error);
                    }
                });
            });
        </script>
    @endsection
</x-views.edit-blade>
