<x-views.create-blade>
    @php
        $urlSegments = explode('/', url()->previous());
        $type = end($urlSegments);
        $type = isset($urlSegments[count($urlSegments) - 2]) ? $urlSegments[count($urlSegments) - 2] : null;
        if ($type == 'type') {
            $val = end($urlSegments);
        }
    @endphp
    <x-form.input-component type="radio" placeholder="Select Report Type" name="type" label="Radio Label"
        :options="[
            'Published' => '0',
            'Upcoming' => '1',
        ]" required="true" :value="old('type', $type ?? '')" />
    <div class="row row-cols-2">
        <x-form.input-component name="category_id" label="Select Report Category" placeholder="Select an option"
            :options="$categories" type="select" required="true" value="{{ old('category_id') }}" />
        <x-form.input-component name="subcategory_id" label="Select Report SubCategory" placeholder="Select an option"
            type="select" required="true" value="{{ old('subcategory_id') }}" />
    </div>
    <x-form.input-component name="report_title" label="Report Title" placeholder="Report Title"
        value="{{ old('report_title') }}" required="true" />
    <div class="row row-cols-2">
        <x-form.input-component name="report_name" label="Report Short Title" placeholder="Report Short Title"
            value="{{ old('report_name') }}" required="true" />
        <x-form.input-component name="slug" label="Slug" placeholder="Slug" value="{{ old('slug') }}"
            required="true" />
    </div>
    <label for="description">Description <span class="text-danger"> * </span> </label>
    <x-form.input-component name="description" type="textarea" class="ckeditor" label="Description"
        placeholder="Description" value="{{ old('description') }}" />
    <label for="toc">Toc <span class="text-danger"> * </span> </label>
    <x-form.input-component name="toc" type="textarea" class="ckeditor" label="Toc" placeholder="Toc"
        value="{{ old('toc') }}" />
    <label for="industry_glance">List of Table & Figure <span class="text-danger"> * </span> </label>
    <x-form.input-component name="industry_glance" type="textarea" class="ckeditor" label="List of Table & Figure"
        placeholder="List of Table & Figure" value="{{ old('industry_glance') }}" />
    <label for="research_scope">Key Companies <span class="text-danger"> * </span> </label>
    <x-form.input-component name="research_scope" type="textarea" class="ckeditor" label="Key Companies"
        placeholder="Key Companies" value="{{ old('research_scope') }}" />
    <div class="row row-cols-3">
        <x-form.input-component name="pages" type='number' label="Number Of Pages" placeholder="Number Of Pages"
            value="{{ old('pages') }}" required="true" />
        <x-form.input-component name="no_of_table" type='number' label="Number Of Table" placeholder="Number Of Table"
            value="{{ old('no_of_table') }}" required="true" />
        <x-form.input-component name="figure" type='number' label="Number Of Figure" placeholder="Number Of Figure"
            value="{{ old('figure') }}" required="true" />
    </div>
    <div class="row row-cols-3">
        <x-form.input-component name="price" type='number' label="Single User" placeholder="Single User"
            value="{{ old('price', 3975) }}" required="true" />
        <x-form.input-component name="corporate_cost" type='number' label="Multi User" placeholder="Multi User"
            value="{{ old('corporate_cost', 4975) }}" required="true" />
        <x-form.input-component name="enterprise_cost" type='number' label="Enterprise Cost"
            placeholder="Enterprise Cost" value="{{ old('enterprise_cost', 6975) }}" required="true" />
    </div>
    <div class="row row-cols-3">
        <x-form.input-component name="image_path1" type='text' label="Image Url 1st" placeholder="Image Url 1st"
            value="{{ old('image_path1') }}" />
        <x-form.input-component name="image_path2" type='text' label="Image Url 2nd" placeholder="Image Url 2nd"
            value="{{ old('image_path2') }}" />
        <x-form.input-component name="image_path3" type='text' label="Image Url 3rd" placeholder="Image Url 3rd"
            value="{{ old('image_path3') }}" />
    </div>
    <div class="row row-cols-3 my-2">
        <div id="image_Preview1"></div>
        <div id="image_Preview2"></div>
        <div id="image_Preview3"></div>
    </div>
    <div class="row row-cols-2 my-2">
        <x-form.input-component name="video_path" type='text' label="Video Url" placeholder="Video Url"
            value="{{ old('video_path') }}" />
        <div id="video_preview"></div>
    </div>
    <x-form.input-component type="select" placeholder="Select Region" name="region" label="Select Region"
        class="your-custom-class" :options="[
            'Global' => 'Global',
            'North America' => 'North America',
            'Europe' => 'Europe',
            'Asia Pacific' => 'Asia Pacific',
            'Middle East & North Africa' => 'Middle East & North Africa',
            'Latin America' => 'Latin America',
        ]" required="true" :value="old('region')" />
    <x-form.input-component name="seo_title" label="SEO Title" placeholder="SEO Title"
        value="{{ old('seo_title') }}" required="true" />
    <label for="meta_description">Meta Description <span class="text-danger"> * </span> </label>
    <x-form.input-component name="meta_description" type="textarea" label="Meta Description"
        placeholder="Meta Description" value="{{ old('meta_description') }}" />
    <label for="meta_keyword">Meta Keywords</label>
    <x-form.input-component name="meta_keyword" type="textarea" label="Meta Keywords" placeholder="Meta Keywords"
        value="{{ old('meta_keyword') }}" />
    <x-form.input-component name="p_date" type="date" label="Publish Date" placeholder="Publish Date"
        value="{{ old('p_date') }}" />
    @section('scripts')
        <script>
            $('#image_path1').change(function(e) {
                var container = document.getElementById('image_Preview1');
                container.innerHTML = "<img src='" + $('#image_path1').val() +
                    "' alt='User's Image' height='50' width='50' >";
            });
            $('#image_path2').change(function(e) {
                var container = document.getElementById('image_Preview2');
                container.innerHTML = "<img src='" + $('#image_path2').val() +
                    "' alt='User's Image' height='50' width='50' >";
            });
            $('#image_path3').change(function(e) {
                var container = document.getElementById('image_Preview3');
                container.innerHTML = "<img src='" + $('#image_path3').val() +
                    "' alt='User's Image' height='50' width='50' >";
            });
            $('#video_path').change(function(e) {
                var container = document.getElementById('video_preview');
                var videoUrl = $('#video_path').val();
                var videoId = extractYouTubeVideoId(videoUrl);
                var iframeCode = '<iframe width="560" height="315" src="https://www.youtube.com/embed/' + videoId +
                    '" frameborder="0" allowfullscreen></iframe>';
                container.innerHTML = iframeCode;
            });

            $('#report_name').change(function(e) {
                var title = $(this).val();
                var modelName = 'Report';
                $.ajax({
                    type: 'GET',
                    url: '{{ route('generateSlug') }}',
                    data: {
                        title: title,
                        modelName: modelName
                    },
                    dataType: 'json',
                    success: function(data) {
                        $('#slug').val(data.slug);
                    },
                    error: function(error) {
                        console.error('Ajax error:', error);
                    }
                });
            });
            $('#category_id').change(function(e) {
                var category_id = $(this).val();
                $.ajax({
                    type: 'GET',
                    url: '{{ route('getReportSubCategory') }}',
                    data: {
                        category_id: category_id
                    },
                    dataType: 'json',
                    success: function(data) {
                        var selectBox = $('#subcategory_id');
                        selectBox.empty();
                        selectBox.append(
                            '<option value="" disabled selected>Select Report SubCategory</option>');
                        $.each(data.subcats, function(label, value) {
                            selectBox.append('<option value="' + value + '">' + label +
                                '</option>');
                        });
                    },
                    error: function(error) {
                        console.error('Ajax error:', error);
                    }
                });
            });
            var today = new Date();
            var dd = String(today.getDate()).padStart(2, '0');
            var mm = String(today.getMonth() + 1).padStart(2, '0'); // January is 0!
            var yyyy = today.getFullYear();

            today = yyyy + '-' + mm + '-' + dd;

            document.getElementById('p_date').value = today;
        </script>
    @endsection
</x-views.create-blade>
