<x-views.edit-blade label="News Category">
    <form method="post" action="{{ route($curr_url_1 . '.' . $curr_url_2 . '.update',$newscategory->id) }}" @class(['p-4'])>
        @csrf
        @method('PUT')
        <x-form.input-component name="news_category" label="{{ ucfirst($curr_url_2) }}"
            placeholder="{{ ucfirst($curr_url_2) }}" value="{{ $newscategory->news_category }}" required="true" />
        <x-form.input-component name="slug" label="Slug" placeholder="Slug" value=" {{ $newscategory->slug }}"
            required="true" />
        <label for="description">Description <span class="text-danger"> * </span> </label>
        <x-form.input-component name="description" type="textarea" class="ckeditor" label="Description"
            placeholder="Description" value=" {!! $newscategory->description !!}" />
        <x-form.input-component name="seo_title" label="SEO Title" placeholder="SEO Title"
            value=" {{ $newscategory->seo_title }}" required="true" />
        <label for="meta_description">Meta Description <span class="text-danger"> * </span> </label>
        <x-form.input-component name="meta_description" type="textarea" label="Meta Description"
            placeholder="Meta Description" value=" {!! $newscategory->meta_description !!}" />
        <label for="meta_keywords">Meta Keywords</label>
        <x-form.input-component name="meta_keywords" type="textarea" label="Meta Keywords" placeholder="Meta Keywords"
            value=" {{ $newscategory->meta_keywords }}" />
        <button type="submit" class="btn btn-success mt-2">Save {{ ucfirst($curr_url_2) }}</button>
    </form>
    @section('scripts')
        <script>
            $('#news_category').change(function(e) {
                var title = $(this).val();
                var modelName = 'NewsCategory';

                $.ajax({
                    type: 'GET',
                    url: '{{ route('generateSlug') }}',
                    data: {
                        title: title,
                        modelName: modelName
                    },
                    dataType: 'json',
                    success: function(data) {
                        $('#slug').val(data.slug);
                    },
                    error: function(error) {
                        console.error('Ajax error:', error);
                    }
                });
            });
        </script>
    @endsection
</x-views.edit-blade>
