<x-views.index-blade>
    <form action="{{ route('admin.news.index') }}" method="get" id='filter-form'>
        <div class="row">
            <div class="col-4">
                <x-form.input-component name="category_id" label="Domain" placeholder="Domain"
                    :options="$domains" type="select" value="{{ request('category_id', old('category_id')) }}" />
            </div>
            <div class="col-4">
                <x-form.input-component name="subcategory_id" label="Sub-Domain" class="select2"
                    placeholder="Sub-Domain" :options="$categories" type="select"
                    value="{{ request('subcategory_id', old('subcategory_id')) }}" />
            </div>
            <div class="col-4">
                <button type="submit"  id="search" class="btn btn-primary"><i class="fa fa-search" aria-hidden="true"></i></button>
                <a href="{{ route('admin.report.index') }}" class="btn btn-danger"> Reset </a>
            </div>
        </div>
    </form>
    {{  $dataTable->table(['class' => 'table table-bordered'])  }}
    @section('scripts')
        {{ $dataTable->scripts(attributes: ['type' => 'module']) }}
        <script>
            $('#category_id').change(function(e) {
                var category_id = $(this).val();
                $.ajax({
                    type: 'GET',
                    url: '{{ route('getReportSubCategory') }}',
                    data: {
                        category_id: category_id
                    },
                    dataType: 'json',
                    success: function(data) {
                        var selectBox = $('#subcategory_id');
                        selectBox.empty();
                        selectBox.append('<option value="" disabled selected>Sub-Domain</option>');
                        $.each(data.subcats, function(label, value) {
                            selectBox.append(`<option value="${value}"  > ${label}</option>`);
                        });
                    },
                    error: function(error) {
                        console.error('Ajax error:', error);
                    }
                });
            });
        </script>
    @endsection
</x-views.index-blade>
