@extends('layouts.app')

@section('content')
<div class="container">
    @if ($errors->any())
    <div class="alert alert-danger">
        <ul>
            @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
    @endif
    <form method="post" action="{{ route('admin.apireportslist.store') }}" enctype="multipart/form-data">
        @csrf
        
        <div class="mb-3">
            <label for="report_domain" class="form-label">Report Domain</label>
            <select name="report_domain" id="report_domain" class="form-control" required>
                <option value="" selected disabled>Select Category</option>
                @foreach($categories as $category)
                <option value="{{ $category->id }}">{{ $category->category_title }}</option>
                @endforeach
            </select>
        </div>
        
        <div class="mb-3">
            <label for="report_subdomain" class="form-label">Report Sub Domain</label>
            <select name="report_subdomain" id="report_subdomain" class="form-control" required>
                <option value="" selected disabled>Select Subcategory</option>
            </select>
        </div>
        
        <div class="mb-3">
            <label for="report_title" class="form-label">Report Title</label>
            <input type="text" class="form-control" id="report_title" name="report_title"
            value="{{ $reportdetails['reportname'] }}" required>
        </div>
        
        <div class="mb-3">
            <label for="report_name" class="form-label">Report Short Title</label>
            <input type="text" class="form-control" id="report_name" name="report_name"
            value="{{ $reportdetails['reportname'] }}" required>
        </div>
        
        <div class="mb-3">
            <label for="slug" class="form-label">Slug</label>
            <input type="text" class="form-control" id="slug" name="slug" value="{{ $reportdetails['reportname'] }}" required>
        </div>
        
        <div class="mb-3">
            <label for="description" class="form-label">Description</label>
            <textarea class="form-control" id="description" name="description" rows="4"
            required>{{ old('description') }}</textarea>
        </div>
        
        <div class="mb-3">
            <label for="price" class="form-label">Price</label>
            <input type="number" class="form-control" id="price" name="price" value="150" required>
        </div>
        
        <div class="mb-3">
            <label for="p_date" class="form-label">Publish Date</label>
            <input type="date" class="form-control" id="p_date" name="p_date" value="" required>
        </div>
        
        
        <div class="mb-3">
            <label for="report_title" class="form-label">Region</label>
            <input type="text" class="form-control" id="region" name="region"
            value="{{ old('region') }}" required>
        </div>
        
        <div class="mb-3">
            <label for="report_title" class="form-label">Survey Time Period</label>
            <input type="text" class="form-control" id="survey_time_period" name="survey_time_period"
            value="{{ $reportdetails['base_year'] }}" required>
        </div>
        <div class="mb-3">
            <label for="report_title" class="form-label">Supplementary Notes</label>
            <input type="text" class="form-control" id="supplementary_notes" name="supplementary_notes"
            value="{{ old('supplementary_notes') }}" required>
        </div>
        
        <div class="mb-3">
            <label for="seo_title" class="form-label">SEO Title</label>
            <input type="text" class="form-control" id="seo_title" name="seo_title"
            value="{{ old('seo_title') }}" required>
        </div>
        
        <div class="mb-3">
            <label for="meta_description" class="form-label">Meta Description</label>
            <textarea class="form-control" id="meta_description" name="meta_description" rows="4"
            required>{{ old('meta_description') }}</textarea>
        </div>
        
        <div class="mb-3">
            <label for="meta_keyword" class="form-label">Meta Keywords</label>
            <textarea class="form-control" id="meta_keyword" name="meta_keyword" rows="2"
            placeholder="Optional">{{ old('meta_keyword') }}</textarea>
        </div>
        
        
        
        <div class="mb-3">
            <label for="write_up" class="form-label">Write Up</label>
            <textarea class="ckeditor" id="description" name="write_up" rows="4" 
            placeholder="Optional">{{ old('write_up') }}</textarea>
        </div>
        
        <div class="mb-3">
            <label for="chart_type" class="form-label">Chart Type</label>
            
            <select class="form-control" id="chart_type" required name="chart_type">
                <option value="" selected disabled>Select chart type</option>
                <option value="bar">Bar Chart</option>
                <option value="line">Line Chart</option>
            </select>
        </div>
        <div style="display:flex;gap:70px">
            <div class="mb-3">
                <input type="checkbox" name="is_pdf" value="1"/> 
                <label for="chart_type" class="form-label">PDF Download</label>
            </div>
            <div class="mb-3">
                <input type="checkbox" name="is_xls" value="1"/> 
                <label for="chart_type" class="form-label">XLS Download</label>
            </div>
            <div class="mb-3">
                <input type="checkbox" name="is_png" value="1"/> 
                <label for="chart_type" class="form-label">PNG Download</label>
            </div>
        </div>
        
        
        {{-- Add more form fields as needed --}}
        
        <input type="hidden" name="reportid" value="{{$apireportid}}">
        <input type="hidden" name="json_index" value="{{$json_index}}">
        <button type="submit" class="btn btn-primary">Submit</button>
    </form>
</div>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>

<script>
    jQuery(document).ready(function() {
        jQuery('#report_domain').change(function() {
            var categoryId = jQuery(this).val();
            if (categoryId) {
                $.ajax({
                    url: '/admin/get-subcategories/' + categoryId,
                    type: 'GET',
                    dataType: 'json',
                    success: function(data) {
                        jQuery('#report_subdomain').empty();
                        jQuery('#report_subdomain').append('<option value="">Select Subcategory</option>');
                        $.each(data, function(key, value) {
                            jQuery('#report_subdomain').append('<option value="' + value.id + '">' + value.subcategory_title + '</option>');
                        });
                    }
                });
            } else {
                jQuery('#report_subdomain').empty();
            }
        });

            var currentDate = new Date().toISOString().slice(0, 10);
            document.getElementById("p_date").value = currentDate;

        
    });
</script>

@endsection

<!-- <script>
    ClassicEditor
    .create( document.querySelector( '.ckeditor' ) )
    .catch( error => {
        console.error( error );
    } );
</script> -->

