<x-views.index-blade>
    @php
        // $urlSegments = explode('/', url()->previous());
        // $type = isset($urlSegments[count($urlSegments) - 2]) ? $urlSegments[count($urlSegments) - 2] : null;
        // $val = end($urlSegments);
    @endphp

    <form action="{{ route('admin.report.index') }}" method="get" id='filter-form'>
        <div class="row">
            <div class="col-3">
                <x-form.input-component type="select" placeholder="Select Report type" name="type" label="Select Report Type"
                    :options="[
                        'All' => '*',
                        'Published' => 0,
                        'Upcoming' => 1,
                    ]" :value="request('type', '*')" />
            </div>
            <div class="col-3">
                <x-form.input-component name="category_id" label="Select Category" placeholder="Select Category"
                    :options="$categories" type="select" value="{{ request('category_id', old('category_id')) }}" />
            </div>
            <div class="col-3">
                <x-form.input-component name="subcategory_id" label="Select Subcategory" placeholder="Select Subcategory"
                    :options="$subcats" type="select" value="{{ request('subcategory_id', old('subcategory_id')) }}" />
            </div>
            <div class="col-3">
                <button type="submit"  id="search" class="btn btn-primary"><i class="fa fa-search" aria-hidden="true"></i></button>
                <a href="{{ route('admin.report.index') }}" class="btn btn-danger"> Reset </a>
            </div>
        </div>
    </form>

    {{ $dataTable->table(['class' => 'table table-bordered']) }}

    @section('scripts')
        {{ $dataTable->scripts(attributes: ['type' => 'module']) }}
        <script>
            $('#category_id').change(function(e) {
                var category_id = $(this).val();
                $.ajax({
                    type: 'GET',
                    url: '{{ route('getReportSubCategory') }}',
                    data: {
                        category_id: category_id
                    },
                    dataType: 'json',
                    success: function(data) {
                        var selectBox = $('#subcategory_id');
                        selectBox.empty();
                        selectBox.append('<option value="" disabled selected>Select Subcategory</option>');
                        $.each(data.subcats, function(label, value) {
                            selectBox.append(`<option value="${value}"  > ${label}</option>`);
                        });
                    },
                    error: function(error) {
                        console.error('Ajax error:', error);
                    }
                });
            });

        </script>
    @endsection
</x-views.index-blade>
