<x-views.edit-blade>
    <ul class="nav nav-tabs" id="myTab" role="tablist">
        <li class="nav-item" role="presentation">
            <button class="nav-link active" id="home-tab" data-bs-toggle="tab" data-bs-target="#home-tab-pane"
                type="button" role="tab" aria-controls="home-tab-pane" aria-selected="true">Home</button>
        </li>
        <li class="nav-item" role="presentation">
            <button class="nav-link" id="profile-tab" data-bs-toggle="tab" data-bs-target="#profile-tab-pane"
                type="button" role="tab" aria-controls="profile-tab-pane" aria-selected="false">FAQ</button>
        </li>
        <li class="nav-item" role="presentation">
            <button class="nav-link" id="contact-tab" data-bs-toggle="tab" data-bs-target="#contact-tab-pane"
                type="button" role="tab" aria-controls="contact-tab-pane" aria-selected="false">Chart</button>
        </li>
    </ul>
    <div class="tab-content mt-3" id="myTabContent">
        <div class="tab-pane fade show active" id="home-tab-pane" role="tabpanel" aria-labelledby="home-tab"
            tabindex="0">
            <form method="post" action="{{ route($curr_url_1 . '.' . $curr_url_2 . '.update', $report->id) }}"
                @class(['p-4'])>
                @csrf
                @method('PUT')
                <x-form.input-component type="radio" placeholder="Select Report Type" name="type"
                    label="Radio Label" :options="[
                        'Published' => '0',
                        'Upcoming' => '1',
                    ]" required="true" :value="$report->type" />
                <div class="row row-cols-2">
                    <x-form.input-component name="category_id" label="Select Report Category"
                        placeholder="Select an option" :options="$categories" type="select" required="true"
                        value="{{ $report->category_id }}" />
                    <x-form.input-component name="subcategory_id" label="Select Report SubCategory"
                        placeholder="Select an option" type="select" required="true"
                        value="{{ $report->subcategory_id }}" />
                </div>
                <x-form.input-component name="report_title" label="Report Title" placeholder="Report Title"
                    value="{{ $report->report_title }}" required="true" />
                <div class="row row-cols-2">
                    <x-form.input-component name="report_name" label="Report Short Title"
                        placeholder="Report Short Title" value="{{ $report->report_name }}" required="true" />
                    <x-form.input-component name="slug" label="Slug" placeholder="Slug" value="{{ $report->slug }}"
                        required="true" />
                </div>
                <label for="description">Description <span class="text-danger"> * </span> </label>
                <x-form.input-component name="description" type="textarea" class="ckeditor" label="Description"
                    placeholder="Description" value="{!! $report->description !!}" />
                <label for="toc">Toc <span class="text-danger"> * </span> </label>
                <x-form.input-component name="toc" type="textarea" class="ckeditor" label="Toc" placeholder="Toc"
                    value="{!! $report->toc !!}" />
                <label for="industry_glance">List of Table & Figure <span class="text-danger"> * </span> </label>
                <x-form.input-component name="industry_glance" type="textarea" class="ckeditor"
                    label="List of Table & Figure" placeholder="List of Table & Figure"
                    value="{!! $report->industry_glance !!}" />
                <label for="research_scope">Key Companies <span class="text-danger"> * </span> </label>
                <x-form.input-component name="research_scope" type="textarea" class="ckeditor" label="Key Companies"
                    placeholder="Key Companies" value="{!! $report->research_scope !!}" />
                <div class="row row-cols-3">
                    <x-form.input-component name="pages" type='number' label="Number Of Pages"
                        placeholder="Number Of Pages" value="{{ $report->pages }}" required="true" />
                    <x-form.input-component name="no_of_table" type='number' label="Number Of Table"
                        placeholder="Number Of Table" value="{{ $report->no_of_table }}" required="true" />
                    <x-form.input-component name="figure" type='number' label="Number Of Figure"
                        placeholder="Number Of Figure" value="{{ $report->figure }}" required="true" />
                </div>
                <div class="row row-cols-3">
                    <x-form.input-component name="price" type='number' label="Single User"
                        placeholder="Single User" value="{{ $report->price }}" required="true" />
                    <x-form.input-component name="corporate_cost" type='number' label="Multi User"
                        placeholder="Multi User" value="{{ $report->corporate_cost }}" required="true" />
                    <x-form.input-component name="enterprise_cost" type='number' label="Enterprise Cost"
                        placeholder="Enterprise Cost" value="{{ $report->enterprise_cost }}" required="true" />
                </div>
                <div class="row row-cols-3">
                    <x-form.input-component name="image_path1" type='text' label="Image Url 1st"
                        placeholder="Image Url 1st" value="{{ $report->image_path1 }}" />
                    <x-form.input-component name="image_path2" type='text' label="Image Url 2nd"
                        placeholder="Image Url 2nd" value="{{ $report->image_path2 }}" />
                    <x-form.input-component name="image_path3" type='text' label="Image Url 3rd"
                        placeholder="Image Url 3rd" value="{{ $report->image_path3 }}" />
                </div>
                <div class="row row-cols-3 my-2">
                    <div id="image_Preview1"></div>
                    <div id="image_Preview2"></div>
                    <div id="image_Preview3"></div>
                </div>
                <div class="row row-cols-2 my-2">
                    <x-form.input-component name="video_path" type='text' label="Video Url"
                        placeholder="Video Url" value="{{ $report->video_path }}" />
                    <div id="video_preview"></div>
                </div>
                <x-form.input-component type="select" placeholder="Select Region" name="region"
                    label="Select Region" class="your-custom-class" :options="[
                        'Global' => 'Global',
                        'North America' => 'North America',
                        'Europe' => 'Europe',
                        'Asia Pacific' => 'Asia Pacific',
                        'Middle East & North Africa' => 'Middle East & North Africa',
                        'Latin America' => 'Latin America',
                    ]" required="true"
                    :value="$report->region" />
                <x-form.input-component name="seo_title" label="SEO Title" placeholder="SEO Title"
                    value="{{ $report->seo_title }}" required="true" />
                <label for="meta_description">Meta Description <span class="text-danger"> * </span> </label>
                <x-form.input-component name="meta_description" type="textarea" label="Meta Description"
                    placeholder="Meta Description" value="{{ $report->meta_description }}" />
                <label for="meta_keyword">Meta Keywords</label>
                <x-form.input-component name="meta_keyword" type="textarea" label="Meta Keywords"
                    placeholder="Meta Keywords" value="{{ $report->meta_keyword }}" />
                <x-form.input-component name="p_date" type="date" label="Publish Date"
                    placeholder="Publish Date" value="{{ $report->p_date }}" />
                <button type="submit" class="btn btn-success mt-2">Save {{ ucfirst($curr_url_2) }}</button>
            </form>
        </div>
        <div class="tab-pane fade" id="profile-tab-pane" role="tabpanel" aria-labelledby="profile-tab"
            tabindex="0">
            <h2 class="m-3">Add New Faq</h2>
            <form action="{{ route('admin.faq.store') }}" method="post">
                @csrf
                <input type="hidden" name="report_id" value="{{ $report->id }}">
                <x-form.input-component name="q" label="Question" placeholder="Question" required="true" />
                <label for="ans" class="ml-3">Answer <span class="text-danger"> * </span> </label>
                <x-form.input-component name="ans" type="textarea" label="Answer" placeholder="Answer"
                    required="true" />
                <button type="submit" class="btn btn-success mt-2">Save Faq</button>
            </form>
            <hr>
            <h2 class="m-3">All Faq</h2>
            @foreach ($faqs as $faq)
                <div class="card">
                    <div class="card-body">
                        <form action="{{ route('admin.faq.update', $faq->id) }}" method="post" class="m-2">
                            @csrf
                            @method('PUT')
                            <input type="hidden" name="report_id" value="{{ $report->id }}">
                            <x-form.input-component name="q" label="Question" placeholder="Question"
                                required="true" value="{{ $faq->q }}" />
                            <label for="ans" class="ml-3">Answer <span class="text-danger"> * </span> </label>
                            <x-form.input-component name="ans" type="textarea" label="Answer"
                                placeholder="Answer" required="true" value="{{ $faq->ans }}" />
                            <button type="submit" class="btn btn-success mt-2">Update Faq</button>
                        </form>
                    </div>
                </div>
            @endforeach
        </div>
        <div class="tab-pane fade" id="contact-tab-pane" role="tabpanel" aria-labelledby="contact-tab"
            tabindex="0">
            <form action="{{ route('admin.reportChart.store') }}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="row row-cols-3">
                    <input type="hidden" name="report_id" value="{{ $report->id }}">
                    <input type="hidden" name="chart_bar" value="">
                    <input type="hidden" name="chart_pie" value="">
                    <div class="col-5">
                        <x-form.input-component name="start_year" type='number' label="Start Year (2010 - 2039)"
                            min="2010" max="2039" placeholder="Start Year (2010 - 2039)"
                            value="{{ $reportChart->start_year ?: 2010 }}" />
                    </div>
                    <div class="col-5">
                        <x-form.input-component name="end_year" type='number' label="End Year  (2011 - 2040)"
                            min="2011" max="2040" placeholder="End Year  (2011 - 2040)"
                            value="{{ $reportChart->end_year ?: 2015 }}" />
                    </div>
                    <div class="col-2">
                        <button type="button" class="btn btn-success" onclick="generateTable()">Generate
                            Table</button>
                    </div>
                </div>
                <div class="row mt-3">
                    <div class="col-12">
                        <div id="tableContainer"></div>
                    </div>
                    <div class="col">
                        <x-form.input-component type="select" placeholder="Select unit" name="unit"
                            label="Select Unit" :options="[
                                'Thousand Units' => 'Th',
                                'Million Units' => 'Mn',
                                'Billion Units' => 'Bn',
                                'Trillion Units' => 'Tn',
                                'Kilotons' => 'Kt',
                                'Metric tons' => 'Mt',
                                'Thousand USD' => 'Tu',
                                'Million USD' => 'Mu',
                                'Billion USD' => 'Bu',
                                'Trillion USD' => 'Tu',
                            ]" required="true" :value="$reportChart->unit" />
                    </div>
                    <div class="col-12">
                        <label for="segments">Segments <span class="text-danger"> * </span> </label>
                        <x-form.input-component name="segments" type="textarea" label="Segments"
                            placeholder="Segments" value="{!! $reportChart->segments !!}" />
                    </div>
                    <div class="col-7">
                        <x-form.input-component type="radio" placeholder="Region" name="region" label="Region"
                            :options="[
                                'North America' => 'na',
                                'Europe' => 'eu',
                                'Asia-Pacific' => 'apac',
                                'Lamea' => 'lamea',
                            ]" required="true" :value="$reportChart->region" />
                    </div>
                    <div class="col-5">
                        <x-form.input-component name="reg_value" label="Region Value" placeholder="Region Value"
                            value="{{ $reportChart->reg_value }}" />
                    </div>
                    <div class="col">
                        <x-form.input-component type="select" placeholder="Show Value" name="value_show"
                            label="Show Value" :options="[
                                'All Column Value' => 'All',
                                'Start & Last Year' => 'Base',
                            ]" required="true" :value="$reportChart->value_show" />
                    </div>
                    <div class="col">
                        <input type="submit" class="btn btn-primary" value="save">
                    </div>
                </div>
            </form>
            <div class="row">
                <div class="col-6">
                    <div id="global_values"></div>
                </div>
                <div class="col-6">
                    <div id="segment_chart"></div>
                </div>
            </div>
        </div>
    </div>
    @section('scripts')
        <script type="text/javascript" src="https://www.premiummarketinsights.com/fusioncharts-dist-develop/fusioncharts.js">
        </script>
        <script type="text/javascript"
            src="https://www.premiummarketinsights.com/fusioncharts-dist-develop/themes/fusioncharts.theme.fusion.js"></script>
        <script>
            $('#image_path1').change(function(e) {
                displayImagePreview('image_path1', 'image_Preview1');
            });
            $('#image_path2').change(function(e) {
                displayImagePreview('image_path2', 'image_Preview2');
            });
            $('#image_path3').change(function(e) {
                displayImagePreview('image_path3', 'image_Preview3');
            });
            $('#video_path').change(function(e) {
                displayVideoPreview('video_path', 'video_preview');
            });
            $('#report_name').change(function(e) {
                var title = $(this).val();
                var modelName = 'Report';
                $.ajax({
                    type: 'GET',
                    url: '{{ route('generateSlug') }}',
                    data: {
                        title: title,
                        modelName: modelName
                    },
                    dataType: 'json',
                    success: function(data) {
                        $('#slug').val(data.slug);
                    },
                    error: function(error) {
                        console.error('Ajax error:', error);
                    }
                });
            });
            $('#category_id').change(function(e) {
                var category_id = $(this).val();
                var subcategory_id = "{{ $report->subcategory_id }}";
                $.ajax({
                    type: 'GET',
                    url: '{{ route('getReportSubCategory') }}',
                    data: {
                        category_id: category_id
                    },
                    dataType: 'json',
                    success: function(data) {
                        var selectBox = $('#subcategory_id');
                        selectBox.empty();
                        selectBox.append(
                            '<option value="" disabled selected>Select Report SubCategory</option>');
                        $.each(data.subcats, function(label, value) {
                            selectBox.append(
                                `<option value="${value}" ${subcategory_id == value ? 'selected' : ''} > ${label} </option>`
                            );
                        });
                    },
                    error: function(error) {
                        console.error('Ajax error:', error);
                    }
                });
            });
            var today = new Date();
            var dd = String(today.getDate()).padStart(2, '0');
            var mm = String(today.getMonth() + 1).padStart(2, '0'); // January is 0!
            var yyyy = today.getFullYear();

            today = yyyy + '-' + mm + '-' + dd;

            document.getElementById('p_date').value = today;

            $('#image_path1, #image_path2, #image_path3, #video_path').trigger('change');
            $('#profile-tab').trigger('click');
            generateTable();

            function generateTable() {
                var startYear = parseInt(document.getElementById('start_year').value);
                var endYear = parseInt(document.getElementById('end_year').value);

                if (startYear < 2010) {
                    alert('Start Year must be greater than 2010.');
                    return;
                }

                if (startYear >= endYear) {
                    alert('End Year must be greater than Start Year.');
                    return;
                }

                var table = '<table class="table table-bordered table-striped">';
                table += '<thead class="thead-dark"><tr>';

                for (var year = startYear; year <= endYear; year++) {
                    table += '<th style="width:50px !important;" >' + year + '</th>';
                }
                table += '</tr></thead>';
                table += '<tbody><tr>';
                var reportChartValues = JSON.parse(@json($reportChart->year_data));
                for (var year = startYear; year <= endYear; year++) {
                    var inputValue = '';
                    @if ($reportChart->year_data)
                        inputValue = reportChartValues['values-' + year];
                    @endif
                    table += '<td style="width:50px !important;"><input type="text" name="values-' + year +
                        '" style="width:50px !important;" value="' + inputValue + '" ></td>';
                }
                table += '</tr></tbody>';
                table += '</table>';
                document.getElementById('tableContainer').innerHTML = table;
            }
            // console.log(` vip ${document.getElementById('report_name').value} Revenue, ${document.getElementById('start_year').value}-${document.getElementById('end_year').value} (${document.getElementById('unit').options[document.getElementById('unit').selectedIndex].text})`);
            const convertChartImage = () => {
                // FusionCharts.batchExport({
                //     "charts": [{
                //         "id": `g_values${document.getElementById('slug').value}-column-chart`,
                //     }],
                //     "exportFileName": `${document.getElementById('slug').value}-column-chart`,
                //     "exportFormat": "png",
                //     "quality": "best"
                // });
                // FusionCharts.batchExport({
                //     "charts": [{
                //         "id":  `s_values${document.getElementById('slug').value}-pie-chart`,
                //     }],
                //     "exportFileName": `${document.getElementById('slug').value}-pie-chart`,
                //     "exportFormat": "png",
                //     "quality": "best"
                // });

                var startYear = parseInt(document.getElementById("start_year").value);
                var endYear = parseInt(document.getElementById("end_year").value);
                var yearArray = [];
                var revArray = [];
                for (var year = startYear, p = 0; year <= endYear; year++, p++) {
                    var inputValue;
                    var inputValue = document.getElementsByName('values-' + year)[0].value;
                    if (inputValue == null || inputValue == 'null') {
                        var lastYearValue = document.getElementsByName('values-' + (year - 1))[0].value;
                        var nextYearValue = document.getElementsByName('values-' + (year + 1))[0].value;
                        inputValue = (parseInt(lastYearValue) + parseInt(nextYearValue)) / 2;
                    }
                    yearArray.push(year);
                    revArray.push(inputValue);
                    if (p !== 0 && p !== (endYear - startYear)) {
                        // console.log("Tooltext: XX ($ " + unit + ")");
                    }
                }
                var data = yearArray.map(function(year, index) {
                    return {
                        label: year.toString(),
                        value: revArray[index],

                    };
                });
                FusionCharts.ready(function() {
                    var revenueChart = new FusionCharts({
                        id: `g_values${document.getElementById('slug').value}-column-chart`,
                        type: 'column2d',
                        renderAt: 'global_values',
                        width: '100%',
                        // height: '330',
                        dataFormat: 'json',
                        dataSource: {
                            "chart": {
                                caption: `${document.getElementById('report_name').value} Revenue, ${document.getElementById('start_year').value}-${document.getElementById('end_year').value} (${document.getElementById('unit').options[document.getElementById('unit').selectedIndex].text})`,
                                xaxisname: "Source : Next Move Strategy Consulting",
                                exportEnabled: '1',
                                yaxisname: `Revenues ($ ${document.getElementById('unit').value})`,
                                "numberPrefix": "",
                                "useroundedges": "1",
                                "showHoverEffect": "1",
                                plottooltext: `<b>$value</b> ($ ${document.getElementById('unit').value})`,
                                "theme": "fusion"
                            },
                            "data": data
                        }
                    });
                    revenueChart.render();
                });
                var piedata = [];
                var segments = $('#segments').val().split('#').filter(Boolean);
                var piedata = segments.map(function(segment, index) {
                    return {
                        label: segment,
                        value: '1',
                        tooltext: segment
                    };
                });
                FusionCharts.ready(function() {
                    var doughnutChart = new FusionCharts({
                        id: `s_values${document.getElementById('slug').value}-pie-chart`,
                        type: 'doughnut3d',
                        renderAt: 'segment_chart',
                        width: '100%',
                        // height: '330',
                        dataFormat: 'json',
                        dataSource: {
                            "chart": {
                                caption: `${document.getElementById('report_name').value} Segments`,
                                subcaption: "Source : Next Move Strategy Consulting",
                                exportEnabled: '1',
                                numbersuffix: " MMbbl",
                                usedataplotcolorforlabels: "1",
                                showLegend: "0",
                                showValues: "0",
                                theme: "fusion"
                            },
                            "data": piedata
                        }
                    });
                    doughnutChart.render();
                });
            };
            @if ($reportChart->id)
                convertChartImage();
            @endif
        </script>
    @endsection
</x-views.edit-blade>
