<?php

namespace Database\Seeders;

// use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        // \App\Models\User::factory(10)->create();

        // \App\Models\User::factory()->create([
        //     'name' => 'Vipul Garg',
        //     'email' => 'iamvipulgarg@yahoo.com',
        //     'password' => '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', // password
        // ]);

        $this->call(PermissionSeeder::class);
        $this->call(RoleSeeder::class);
        $this->call(UserSeeder::class);
        $this->call(ReportCategorySeeder::class);
        $this->call(ReportSubCategorySeeder::class);
        $this->call(ReportSeeder::class);
        // $this->call(NewsCategorySeeder::class);
        $this->call(NewsSeeder::class);
        // $this->call(BlogCategorySeeder::class);
        $this->call(BlogSeeder::class);
        \App\Models\Faq::create([
            'q' => 'What will be the worth of global Baker Mixer market by the end of 2030?',
            'ans' => 'According to the report published by Next Move Strategy Consulting, the Baker Mixer market business is expected to hit at $6.73 billion (USD) by 2030.',
            'report_id'=> '1'
        ]);
        \App\Models\Faq::create([
            'q' => 'Which region is expected to hold the highest market share in the Baker Mixer Market?',
            'ans' => 'Europe is expected to hold the highest market share in the global market. The region is expected to witness remarkable growth as it houses the major key players in the market.',
            'report_id'=> '1'
        ]);
        \App\Models\ReportChart::create([
            'year_data' => '{"values-2010":"20","values-2011":30,"values-2012":40,"values-2013":50,"values-2014":60,"values-2015":70,"values-2016":"80"}',
            'start_year'=>'2010',
            'end_year'=>'2016',
            'unit'=>'th',
            'segments'=>'#ww#dd#FF',
            'region'=>'eu',
            'reg_value'=>'ww',
            'value_show'=>'All',
            'report_id'=>'1',
        ]);
        \App\Models\Newsletter::create([
            'email' => 'iamvipulgarg@yahoo.com',
        ]);
        \App\Models\Newsletter::create([
            'email' => 'vipulgarg@yahoo.com',
        ]);
        \App\Models\Newsletter::create([
            'email' => 'gargvipul@yahoo.com',
        ]);
        \App\Models\OurSection::create([
            'type' => 'Our clients',
            'image_url' => 'https://www.nextmsc.com/assets/frontend/images/NM02.png',
        ]);
        \App\Models\OurSection::create([
            'type' => 'Featured in News',
            'image_url' => 'https://www.nextmsc.com/assets/frontend/images/welcome.jpg',
        ]);
        \App\Models\OurSection::create([
            'type' => 'Channel Partners',
            'image_url' => 'https://www.nextmsc.com/uploads/images/Electric_Shaver.png',
        ]);
        \App\Models\Enquiry::create([
            'name' => 'Vipul Garg',
            'email' => 'gargvipul@yahoo.com',
            'country_code' => '+91',
            'phone' => '965430158',
            'message' => 'Test Message',
            'type' => 'download sample',
            'reffer' => 'https://www.nextmsc.com/blogs',
            'report_id' => '1',
        ]);
        \App\Models\Career::create([
            'title' => 'Sales Executive',
            'summary' => 'As a Sales Executive at Next Move Strategy Consulting, you will play a pivotal role in driving sales growth and expanding our client base. You will be responsible for generating new business leads, nurturing client relationships, and closing sales deals. This position requires strong sales acumen, excellent communication skills, and a deep understanding of the market research industry. If you are a self-motivated and results-driven individual with a passion for sales and a knack for building strong client relationships, we invite you to join our dynamic team',
            'responsiblity' => 'Identify and pursue new business opportunities by proactively generating leads and establishing connections with potential clients.
            Conduct market research and analysis to identify target industries and sectors for sales prospecting.
            Build and maintain strong relationships with existing clients to foster loyalty and secure repeat business.
            Deliver persuasive sales presentations and product demonstrations to prospective clients, showcasing the value and benefits of our syndicated market research reports.
            Understand client needs, provide customized solutions, and effectively communicate the unique value propositions of our reports to drive sales conversions.
            Collaborate with the marketing team to develop and implement effective sales strategies, campaigns, and promotional materials.
            Utilize CRM systems and sales tools to track sales activities, manage leads, and monitor the sales pipeline.
            Stay updated on industry trends, market dynamics, and competitor activities to identify opportunities for growth and differentiation.
            Attend industry conferences, trade shows, and networking events to expand professional networks and generate new sales leads.
            Collaborate with internal teams, including research, marketing, and customer support, to ensure client satisfaction and seamless execution of sales processes.',
            'skills' => 'Proven experience in sales, preferably within the market research industry or a related field.',
            'location' => 'India',
            'job_type' => 'Full Time',
        ]);
        \App\Models\Testimonial::create([
            "name"=>'Vipul Garg',
            "image_url"=>'https://www.nextmsc.com/assets/frontend/images/NM02.png',
            "company"=>'Next MSC',
            "designation"=>'Freelancer',
            "description"=>'Awesome Company',
        ]);
        \App\Models\BlogComment::create([
            "name"=>'Vipul Garg',
            "blog_id"=>'1',
            "email"=>'vipulgarg@gmail.com',
            "comment"=>'Blog Comment test',
        ]);
        \App\Models\NewsComment::create([
            "name"=>'Vipul Garg',
            "news_id"=>'1',
            "email"=>'vipulgarg@gmail.com',
            "comment"=>'News Comment test',
        ]);
    }
}
