<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('apireports', function (Blueprint $table) {
            $table->id();
            $table->string('reportid');
            $table->string('json_index');
            $table->string('report_domain')->nullable();
            $table->string('report_subdomain')->nullable();
            $table->string('reporturl')->nullable();
            $table->string('slug')->unique();
            $table->mediumText('report_title');
            $table->string('report_name');
            $table->longText('description');
            $table->string('price');
            $table->date('p_date');
            $table->string('seo_title');
            $table->longText('meta_description');
            $table->string('meta_keyword')->nullable();
            $table->string('image_path1')->nullable();
            $table->mediumText('write_up')->nullable();
            $table->string('chart_type')->nullable();
            $table->string('region')->nullable();
            $table->string('survey_time_period')->nullable();
            $table->string('supplementary_notes')->nullable();
            $table->integer('is_pdf')->nullable();
            $table->integer('is_xls')->nullable();
            $table->integer('is_png')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        //
    }
};
