<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('report_sub_categories', function (Blueprint $table) {
            $table->id();
            $table->string('subcategory_title');
            $table->string('slug');
            $table->longText('description');
            $table->string('subcat_icon')->nullable();
            $table->string('seo_title');
            $table->longText('meta_description');
            $table->foreignId('category_id')->constrained('report_categories')->onDelete('cascade');
            $table->timestamps();
            $table->unique(['category_id', 'slug']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('report_sub_categories');
    }
};
