<?php

namespace App\View\Components\Form;

use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;

class InputComponent extends Component
{
    public $type;
    public $name;
    public $label;
    public $placeholder;
    public $value;
    public $required;
    public $class;
    public $options;
    public $min;
    public $max;
    /**
     * Create a new component instance.
     */
    public function __construct($name, $label, $placeholder, $value = null, $type = 'text', $required = false, $class = '', $options=[],$min='',$max='')
    {
        $this->type = $type;
        $this->name = $name;
        $this->label = $label;
        $this->placeholder = $placeholder;
        $this->value = $value;
        $this->required = $required;
        $this->class = $class;
        $this->options = $options;
        $this->min = $min;
        $this->max = $max;
    }

    /**
     * Get the view / contents that represent the component.
     */
    public function render(): View|Closure|string
    {
        return view('components.form.input-component');
    }
}
