<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
class NewsComment extends Model
{
    use HasFactory;
    protected $fillable = [
        "name",
        "news_id",
        "email",
        "comment",
        "status",
    ];
    public function news(): BelongsTo
    {
        return $this->belongsTo(News::class, 'news_id');
    }
}
