<?php

namespace App\Models;

use App\Models\News;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Spatie\Activitylog\LogOptions;
use Spatie\Activitylog\Traits\LogsActivity;

class NewsCategory extends Model
{
    use HasFactory, LogsActivity;
    protected $fillable = [
        "news_category",
        "slug",
        "description",
        "seo_title",
        "meta_description",
        "meta_keywords",
    ] ;

    public function news(): HasMany
    {
        return $this->hasMany(News::class, 'category_id');
    }
    public function getActivitylogOptions(): LogOptions
    {
        return LogOptions::defaults()
        ->useLogName('news_categories')
        ->dontLogIfAttributesChangedOnly(['updated_at'])
        ->logOnlyDirty()
        ->logFillable();
        // ->logOnly(['name', 'text']);
        // Chain fluent methods for configuration options
    }
}
