<?php

namespace App\Models;

use App\Models\NewsCategory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Spatie\Activitylog\LogOptions;
use Spatie\Activitylog\Traits\LogsActivity;
use Illuminate\Database\Eloquent\Relations\HasMany;
class News extends Model
{
    use HasFactory, LogsActivity;

    protected $fillable = [
        "news_title",
        "slug",
        "news_description",
        "image_url",
        "seo_title",
        "meta_description",
        "p_date",
        "category_id",
    ] ;

    public function category(): BelongsTo
    {
        return $this->belongsTo(ReportSubCategory::class, 'category_id');
    }
    public function newsComments(): HasMany
    {
        return $this->hasMany(NewsComment::class, 'news_id');
    }
    public function getActivitylogOptions(): LogOptions
    {
        return LogOptions::defaults()
        ->useLogName('news')
        ->dontLogIfAttributesChangedOnly(['updated_at'])
        ->logOnlyDirty()
        ->logFillable();
    }
}
