<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Spatie\Activitylog\LogOptions;
use Spatie\Activitylog\Traits\LogsActivity;

class BlogCategory extends Model
{
    use HasFactory, LogsActivity;
    protected $fillable = [
        "blog_category",
        "slug",
        "description",
        "seo_title",
        "meta_description",
        "meta_keywords",
    ] ;

    public function blog(): HasMany
    {
        return $this->hasMany(Blog::class, 'category_id');
    }
    public function getActivitylogOptions(): LogOptions
    {
        return LogOptions::defaults()
        ->useLogName('blog_categories')
        ->dontLogIfAttributesChangedOnly(['updated_at'])
        ->logOnlyDirty()
        ->logFillable();
        // ->logOnly(['name', 'text']);
        // Chain fluent methods for configuration options
    }
}
