<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Spatie\Activitylog\LogOptions;
use Spatie\Activitylog\Traits\LogsActivity;
use Illuminate\Database\Eloquent\Relations\HasMany;
class Blog extends Model
{
    use HasFactory, LogsActivity;

    protected $fillable = [
        "blog_title",
        "slug",
        "blog_description",
        "image_url",
        "seo_title",
        "meta_description",
        "p_date",
        "category_id",
    ] ;

    public function blogCategory(): BelongsTo
    {
        return $this->belongsTo(ReportSubCategory::class, 'category_id');
    }
    public function blogComments(): HasMany
    {
        return $this->hasMany(BlogComment::class, 'blog_id');
    }
    public function getActivitylogOptions(): LogOptions
    {
        return LogOptions::defaults()
        ->useLogName('blogs')
        ->dontLogIfAttributesChangedOnly(['updated_at'])
        ->logOnlyDirty()
        ->logFillable();
    }
}
