<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Spatie\Activitylog\LogOptions;
use Spatie\Activitylog\Traits\LogsActivity;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\HasOne;
use Carbon\Carbon;

class ApiReport extends Model
{
    use HasFactory, LogsActivity;

    protected $table = 'apireports'; // Matching the table name from the migration
    protected $primaryKey = 'id'; // Specifying the primary key

    protected $fillable = [
        'reportid',
        'json_index',
        'tool_table_name',
        'reporturl',
        'slug',
        'report_title',
        'report_name',
        'description',
        'price',
        'p_date',
        'seo_title',
        'meta_description',
        'meta_keyword',
        'image_path1',
        'write_up',
        'chart_type',
        "release_date",
        "region",
        "survey_time_period",
        "supplementary_notes",
        "is_pdf",
        "is_xls",
        "is_png",
    ];

    // protected $casts = [
    //     'p_date' => 'date',
    // ];

    public function getFormattedPDateAttribute()
    {
        return $this->attributes['p_date'] ? Carbon::parse($this->attributes['p_date'])->format('d-M-Y') : null;
    }

    public function getActivitylogOptions(): LogOptions
    {
        return LogOptions::defaults()
            ->useLogName('apireports')
            ->dontLogIfAttributesChangedOnly(['updated_at'])
            ->logOnlyDirty()
            ->logFillable();
    }
}
