<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class ReportSubCategoryRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $rules = [
            'subcategory_title' => 'required|string',
            'description' => 'required|string',
            'subcat_icon' => 'string',
            'seo_title' => 'required|string',
            'meta_description' => 'required|string',
            'category_id' => 'required',
        ];
        if ($this->isMethod('put') || $this->isMethod('patch')) {
            $categoryId = $this->route('reportsubcategory')->id;
            $rules['slug'] = 'required|string|unique:report_sub_categories,slug,' . $categoryId;
        } else {
            $rules['slug'] = 'required|string|unique:report_sub_categories';
        }
        return $rules;
    }
}
