<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class ReportRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $rules = [
            'type' => 'required|integer',
            'category_id' => 'required|integer',
            'subcategory_id' => 'required|integer',
            'report_title' => 'required|string',
            'report_name' => 'required|string',
            'pages' => 'required|string',
            'no_of_table' => 'required|string',
            'figure' => 'required|string',
            'description' => 'required|string',
            'industry_glance' => 'required|string',
            'research_scope' => 'required|string',
            'toc' => 'required|string',
            'price' => 'required|string',
            'corporate_cost' => 'required|string',
            'enterprise_cost' => 'required|string',
            'p_date' => 'required',
            'region' => 'required|string',
            'seo_title' => 'required|string',
            'meta_description' => 'required|string',
            'meta_keyword' => 'string',
            'image_path1' => 'sometimes|string',
            'image_path2' => 'sometimes|string',
            'image_path3' => 'sometimes|string',
            'video_path' => 'sometimes|string',
            'write_up' => 'string',
            'chart_type' => 'string',
            'coupon_code' => 'string',
            'coupon_discount' => 'string',
        ];
        if ($this->isMethod('put') || $this->isMethod('patch')) {
            $id = $this->route('report')->id;
            $rules['slug'] = 'required|string|unique:reports,slug,' . $id;
        } else {
            $rules['slug'] = 'required|string|unique:reports';
        }
        return $rules;
    }
}
