<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class ReportCategoryRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $rules = [
            'category_title' => 'required|string',
            'description' => 'required|string',
            'image' => 'required|string|url',
            'icon' => 'string',
            'seo_title' => 'required|string',
            'meta_description' => 'required|string',
            'meta_keyword' => 'string',
        ];
        if ($this->isMethod('put') || $this->isMethod('patch')) {
            $categoryId = $this->route('reportcategory')->id;
            // dd($categoryId);
            $rules['slug'] = 'required|string|unique:report_categories,slug,' . $categoryId;
        } else {
            $rules['slug'] = 'required|string|unique:report_categories';
        }
        return $rules;
    }
}
