<?php

namespace App\Http\Controllers;

use App\Models\ReportCategory;
use App\Http\Requests\ReportCategoryRequest;

class ReportCategoryController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {

        $reportcategory = ReportCategory::latest()->get();
        return view('admin.reportcategory.index', compact('reportcategory'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('admin.reportcategory.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(ReportCategoryRequest $request)
    {
        ReportCategory::create($request->validated());
        return redirect()->route('admin.reportcategory.index')->with('success', 'Report category created successfully.');
    }

    /**
     * Display the specified resource.
     */
    public function show(ReportCategory $reportcategory)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(ReportCategory $reportcategory)
    {
        return view('admin.reportcategory.edit', compact('reportcategory'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(ReportCategoryRequest $request, ReportCategory $reportcategory)
    {
        $reportcategory->update($request->validated());
        return redirect()->route('admin.reportcategory.index')->with('success', 'Report category Updated successfully.');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(ReportCategory $reportcategory)
    {
        $reportcategory->delete();
        return back()->with('success', 'Report category Deleted Successfully');
    }
}
