<?php

namespace App\Http\Controllers;

use App\DataTables\OurSectionDataTable;
use App\Models\OurSection;
use App\Http\Requests\OurSectionRequest;
use Illuminate\Http\Request;
class OurSectionController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(OurSectionDataTable $dataTable)
    {
        return $dataTable->render('admin.ourSection.index');
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('admin.ourSection.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(OurSectionRequest $request)
    {
        OurSection::create($request->validated());
        return redirect()->route('admin.ourSection.index')->with('success', 'Our Section created successfully.');
    }

    /**
     * Display the specified resource.
     */
    public function show(OurSection $ourSection)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(OurSection $ourSection)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(OurSectionRequest $request, OurSection $ourSection)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(OurSection $ourSection)
    {
        $ourSection->delete();
        return back()->with('success', 'Our Section Deleted Successfully');
    }
    public function updateStatus(Request $request)
    {
        $ourSection=OurSection::findorfail($request->id);
        $ourSection->status = $request->status;
        $ourSection->save();
    }
}
