<?php

namespace App\Http\Controllers;

use App\Models\Newsletter;
use Illuminate\Http\Request;
use App\DataTables\NewsletterDataTable;
class NewsletterController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(NewsletterDataTable $dataTable)
    {
        return $dataTable->render('admin.newsletter.index');
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'email' => 'required|email|unique:newsletter_subscribers,email',
        ]);

        Newsletter::createOrFirst([
            'email' => $request->input('email'),
        ]);
        return back()->with('success', 'News Letter Created Successfully');
    }

    /**
     * Display the specified resource.
     */
    public function show(Newsletter $newsletter)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Newsletter $newsletter)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Newsletter $newsletter)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Newsletter $newsletter)
    {
        $newsletter->delete();
        return back()->with('success', 'News Letter Deleted Successfully');
    }
}
