<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Str;

class CommonController extends Controller
{
    /**
     * Generate and check the uniqueness of a slug via Ajax.
     *
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function generateSlug(Request $request)
    {
        $modelName = $request->input('modelName');
        $title = $request->input('title');

        $slug = Str::slug($title);
        $model = app("App\\Models\\{$modelName}");

        // Check uniqueness in the database
        $originalSlug = $slug;
        $counter = 1;

        while ($model->where('slug', $slug)->exists()) {
            $slug = $originalSlug . '-' . $counter;
            $counter++;
        }

        return response()->json(['slug' => $slug]);
    }
    public function getReportSubCategory(Request $request)
    {
        $subcats = \App\Models\ReportSubCategory::where('category_id', $request->input('category_id'))->pluck('id', 'subcategory_title')->toArray();
        return response()->json(['subcats' => $subcats]);
    }
    public function getReportadvanceSearch(Request $request)
    {
        $results = '';
        if ($request->has('type')) {
            if ($request->input('type') == 'type') {
                $results = [
                    'Published' => 0,
                    'Upcoming' => 1,
                ];
            } else if ($request->input('type') == 'category_id') {
                $results = \App\Models\ReportCategory::pluck('id', 'category_title')->toArray();
            } else if ($request->input('type') == 'subcategory_id') {
                $results = \App\Models\ReportSubCategory::pluck('id', 'subcategory_title')->toArray();
            }
        }
        return response()->json(['results' => $results]);
    }
}
