<?php

namespace App\Http\Controllers;

use App\DataTables\BlogDataTable;
use App\Models\Blog;
use App\Models\ReportCategory;
use App\Models\ReportSubCategory;
use App\Http\Requests\BlogRequest;

class BlogController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(BlogDataTable $dataTable)
    {
        $domains=ReportCategory::pluck('id','category_title')->toArray();
        $categories=ReportSubCategory::pluck('id','subcategory_title')->toArray();
        return $dataTable->render('admin.blogs.index',compact('categories','domains'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $categories = ReportSubCategory::pluck('id','subcategory_title')->toArray();
        return view('admin.blogs.create', compact('categories'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(BlogRequest $request)
    {
        Blog::create($request->validated());
        return redirect()->route('admin.blogs.index')->with('success', 'Blog added successfully.');
    }

    /**
     * Display the specified resource.
     */
    public function show(Blog $blog)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Blog $blog)
    {
        $categories = ReportSubCategory::pluck('id','subcategory_title')->toArray();
        return view('admin.blogs.edit', compact(['blog','categories']));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(BlogRequest $request, Blog $blog)
    {
        $blog->update($request->validated());
        return redirect()->route('admin.blogs.index')->with('success', 'Blog Updated successfully.');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Blog $blog)
    {
        $Blog->delete();
        return back()->with('success', 'Blog Deleted Successfully');
    }
}
