<?php

namespace App\Http\Controllers;

use App\Models\BlogCategory;
use App\Http\Requests\BlogCategoryRequest;

class BlogCategoryController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $blogcategory = blogCategory::latest()->get();
        return view('admin.blogcategory.index', compact('blogcategory'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('admin.blogcategory.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(BlogCategoryRequest $request)
    {
        BlogCategory::create($request->validated());
        return redirect()->route('admin.blogcategory.index')->with('success', 'Blog category created successfully.');
    }

    /**
     * Display the specified resource.
     */
    public function show(BlogCategory $blogcategory)
    {

    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(BlogCategory $blogcategory)
    {
        return view('admin.blogcategory.edit', compact('blogcategory'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(BlogCategoryRequest $request, BlogCategory $blogcategory)
    {
        $blogcategory->update($request->validated());
        return redirect()->route('admin.blogcategory.index')->with('success', 'Blog Category Updated successfully.');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(BlogCategory $blogcategory)
    {
        $blogcategory->delete();
        return back()->with('success', 'Blog Category Deleted Successfully');
    }
}
