<?php

namespace App\Http\Controllers;


use App\Models\ApiReport;
use App\DataTables\ReportDataTable;
use App\Http\Requests\ReportRequest;
use App\Models\ReportCategory;
use App\Models\ReportSubCategory;
use Illuminate\Http\Request;
use Illuminate\Support\Str;


class ApiReportController extends Controller
{
    /**
    * Display a listing of the resource.
    */
    
    
    /**
    * Show the form for creating a new resource.
    */
    public function create()
    {
        
    }
    
    /**
    * Store a newly created resource in storage.
    */
    public function store(Request $request)
    {
        // Validate the incoming request data
        $validatedData = $request->validate([
            'reportid' => 'required|max:255',
            'json_index' => 'required',
            'slug' => 'required|unique:apireports|max:255',
            'report_title' => 'required|max:255',
            'report_name' => 'required|max:255',
            'description' => 'required',
            'price' => 'required|numeric',
            'p_date' => 'required|date',
            'seo_title' => 'required|max:255',
            'meta_description' => 'required',
            'meta_keyword' => 'nullable|max:255',
            'image_path1' => 'nullable|url',
            'write_up' => 'nullable',
            'chart_type' => 'nullable|max:255',
            'region' => 'required',
            'survey_time_period' => 'required',
            'supplementary_notes' => 'required',
            'is_pdf' => 'nullable',
            'is_xls' => 'nullable',
            'is_png' => 'nullable',
            // Add more validation rules for other fields as needed
        ]);
        
        $slug = Str::slug($validatedData['slug']);
        $validatedData['slug'] = $slug;
        
        $apiReport = ApiReport::create($validatedData);
        
        // Redirect to a specific route after successful data submission
        return redirect()->route('admin.apireportslist.index')->with('success', 'Report created successfully.');
    }
    
    
    /**
    * Display the specified resource.
    */
    public function show(ApiReport $apireport)
    {
        //
    }
    
    /**
    * Show the form for editing the specified resource.
    */
    public function edit($reportid)
    {
        dd($reportid);
        // return view('admin.report.edit', compact('report','categories','faqs','reportChart'));
    }
    
    /**
    * Update the specified resource in storage.
    */
    public function update(ReportRequest $request)
    {
        
    }
    
    /**
    * Remove the specified resource from storage.
    */
    public function destroy($report)
    {
        //
    }
    
    
    
    
    public function getDatafromApi($url){
        
        // $url = "http://65.0.6.113:8000/reportgen/getallreports/";
        
        $headers = array(
            "Accept: application/json, text/plain, */*",
            "Accept-Encoding: gzip, deflate",
            "Accept-Language: en-US,en;q=0.9,mr-IN;q=0.8,mr;q=0.7,hi;q=0.6,it;q=0.5",
            "Authorization: Token aed5cabb816d90c7fb08012605d4b3d3083117b1",
            "Origin: http://65.0.6.113",
            "Referer: http://65.0.6.113/"
        );
        
        $ch = curl_init($url);
        
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        
        $response = curl_exec($ch);
        
        if (curl_errno($ch)) {
            echo 'Error: ' . curl_error($ch);
        }
        
        curl_close($ch);
        
        // Handle the $response data here
        
        return $response;
        
        
    }
    
    public function index(ReportDataTable $dataTable){
        $response = $this->getDatafromApi("http://65.0.6.113:8000/reportgen/getallreports/");
        // Decode the JSON response
        $reports = json_decode($response, true);
        // dd($reports);
        
        $counter = 0;

        // Extract required information for display
        $selectedReports = array_map(function ($report) use (&$counter) {
            return [
                'index' => $counter++,
                'reportname' => $report['reportname'],
                'creator' => $report['creator'],
                'createddate' => $report['createddate'],
                'geography' => $report['geography'],
                'base_year' => $report['base_year'],
                'endyear' => $report['endyear'],
                'reportid' => $report['reportid'],
                'excelreport' => $report['excelreport']
            ];
        }, $reports);
        
        // Pass the data to the view for display
        // return view('api_reports.report_list', compact('selectedReports'));
        return $dataTable->render('admin.apireports.index', compact('selectedReports'));
    }
    
    public function editReport($reportid, $json_index, $report_index)
    {
        // Fetch the ApiReport based on $report_id
        // dd($report_id);
        $response = $this->getDatafromApi("http://65.0.6.113:8000/reportgen/getallreports/");
        $reports = json_decode($response, true);
        $reportdetails = $reports[$report_index];
        
        $apiReport = ApiReport::where('reportid','=',$reportid)->where('json_index',$json_index)->first();
        $categories = ReportCategory::all();
        // dd($apiReport);
        
        if(!$apiReport){
            $apireportid = $reportid;
            
            return view('admin.apireports.create', compact('apireportid','json_index','categories','reportdetails'));
        }
        else{
            return view('admin.apireports.edit', compact('apiReport','categories'));
        }
        
        
    }
    
    public function updateApiReport(Request $request){
        
        
        
        $validatedData = $request->validate([
            'reportid' => 'required|max:255',
            'json_index' => 'required',
            'slug' => 'required|max:255', 
            'report_title' => 'required|max:255',
            'report_name' => 'required|max:255',
            'description' => 'required',
            'price' => 'required|numeric',
            'p_date' => 'required|date',
            'seo_title' => 'required|max:255',
            'meta_description' => 'required',
            'meta_keyword' => 'nullable|max:255',
            'image_path1' => 'nullable|url',
            'write_up' => 'nullable',
            'chart_type' => 'nullable|max:255',
            'release_date' => 'required',
            'region' => 'required',
            'survey_time_period' => 'required',
            'supplementary_notes' => 'required',
            'is_pdf' => 'nullable',
            'is_xls' => 'nullable',
            'is_png' => 'nullable',
        ]);
        
        // Fetch the ApiReport based on $reportid
        $report = ApiReport::find($request->id);
        // dd($report);
        
        // Check if the report exists
        if (!$report) {
            return abort(404); // Or handle it in your own way (e.g., redirect to a create view)
        }
        
        $report->update($validatedData);
        
        // Pass the ApiReport to the view for editing
        return redirect()->route('admin.apireportslist.index')->with('success', 'Record updated successfully');
    }
    
    public function viewTables($reportid, $report_index ,ReportDataTable $dataTable){
        $response = $this->getDatafromApi("https://www.jsonkeeper.com/b/BATZ");
        
        $reports = json_decode($response, true);
        
        // dd($reports);
        
        $selectedReports = array_map(function ($index, $report) use ($reportid,$report_index){
            return [
                'index' => $index,
                'report_index' => $report_index,
                'reportid' => $reportid,
                'reportname' => $report['heading']['report_name'] ?? null,
                'tablename' => $report['heading']['table_name'] ?? null,
                'chartheading' => $report['chart_heading'] ?? null,
                'data' => $report['data'] ?? null
            ];
        }, array_keys($reports), $reports);
        
        return $dataTable->render('admin.apireports.tableindex', compact('selectedReports'));
        
    }
    
    public function getSubcategories($categoryId)
    {
        $subcategories = ReportSubCategory::where('category_id', $categoryId)->get();
        
        return response()->json($subcategories);
    }
    
}
