<?php

namespace App\DataTables;

use App\Models\Image;
use Illuminate\Database\Eloquent\Builder as QueryBuilder;
use Yajra\DataTables\EloquentDataTable;
use Yajra\DataTables\Html\Builder as HtmlBuilder;
use Yajra\DataTables\Html\Button;
use Yajra\DataTables\Html\Column;
use Yajra\DataTables\Html\Editor\Editor;
use Yajra\DataTables\Html\Editor\Fields;
use Yajra\DataTables\Services\DataTable;
use Carbon\Carbon;

class ImageDataTable extends DataTable
{
    /**
     * Build the DataTable class.
     *
     * @param QueryBuilder $query Results from query() method.
     */
    public function dataTable(QueryBuilder $query): EloquentDataTable
    {
        return (new EloquentDataTable($query))
            ->addColumn('status', function ($row) {
                return view('admin.image.switch', compact(['row']))->render();
            })
            ->addColumn('action', function ($row) {
                $route='admin.image.destory';
                return "<x-delete-button action='route($route, $row->id)' />";

            })
            ->addColumn('image_url', function ($row) {
                return "<img src='" . $row->image_url . "' height='150px' width='150px' > <button class='btn btn-success' onclick=\"copyToClipboard('" . $row->image_url . "')\"> <i class='fa fa-copy'></i> </button>";
            })
            // ->addColumn('created_at', function ($row) {
            //     $created_at = "";
            //     if ($row->created_at) {
            //         $created_at = date('d-M-Y', strtotime($row->created_at));
            //     }
            //     return $created_at;
            // })
            ->addColumn('created_at', function ($row) {
                $created_at = "";
                if ($row->created_at) {
                    $created_at = Carbon::parse($row->created_at)->diffForHumans();
                }
                return $created_at;
            })
            ->rawColumns(['action', 'status','image_url'])
            ->setRowId('id');
    }

    /**
     * Get the query source of dataTable.
     */
    public function query(Image $model): QueryBuilder
    {
        return $model->newQuery()->latest();
    }

    /**
     * Optional method if you want to use the html builder.
     */
    public function html(): HtmlBuilder
    {
        return $this->builder()
            ->setTableId('image-table')
            ->columns($this->getColumns())
            ->minifiedAjax()
            //->dom('Bfrtip')
            ->orderBy(1)
            ->selectStyleSingle()
            ->buttons([
                Button::make('excel'),
                Button::make('csv'),
                Button::make('pdf'),
                Button::make('print'),
                Button::make('reset'),
                Button::make('reload')
            ]);
    }

    /**
     * Get the dataTable columns definition.
     */
    public function getColumns(): array
    {
        return [
            Column::make('title'),
            Column::make('image_url'),
            Column::make('status'),
            Column::make('created_at'),
            Column::computed('action')
                ->exportable(false)
                ->printable(false)
                ->width(60)
                ->addClass('text-center'),
        ];
    }

    /**
     * Get the filename for export.
     */
    protected function filename(): string
    {
        return 'Image_' . date('YmdHis');
    }
}
